﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

public partial class LabKitOrder : BasePage
{
    private readonly LabKitOrderManager _labkitMgr = new LabKitOrderManager();
    //private readonly int _orderType;
    private UserAccountManager _user = (UserAccountManager)HttpContext.Current.User;


    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            //int InstitutionId = Convert.ToInt32(Request["InstitutionId"]);
            //int KitTypeId = Convert.ToInt16(Request["KitTypeId"]);
            lblOrderType.Text = "New";

            //Save these params in ViewState for later use
            //ViewState["_orderType"] = _orderType;
            //ViewState["InstitutionId"] = InstitutionId;
            //ViewState["KitTypeId"] = KitTypeId;
            //Bind data to screen elements
            //BindData(InstitutionId,KitTypeId);
        }

        //GridViewLabKits.Columns[0].HeaderText = "Order Kit";

        //Only EFR_TEFSC_COORDINATOR and EFR_TEFSC_ADMINISTRATOR can order Lab Kits.
        if (!_user.GetRoles().Contains((int)RoleCode.EFR_TEFSC_COORDINATOR) 
            && !_user.GetRoles().Contains((int)RoleCode.EFR_TEFSC_ADMINISTRATOR))
        {
            btnSave.Enabled = false;
        }
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        List<WKF_CASE_ACTIVITY> activities = new List<WKF_CASE_ACTIVITY>();
        WKF_CASE_ACTIVITY activity;
        
        foreach (GridViewRow Row in GridViewLabKits.Rows)
        {
            //Load form elemets data to objects
            bool chkPatIdChecked = ((CheckBox)Row.FindControl("chkPatId")).Checked;
            bool chkUseStockChecked = ((CheckBox)Row.FindControl("chkUseStock")).Checked;
            if (chkPatIdChecked || chkUseStockChecked)
            {
                //For new case activity - create new
                activity = new WKF_CASE_ACTIVITY();
                activity = LoadFormDataToObjects(activity, Row);

                //use stock vs. order kit
                activity.KIT_USE_STOCK_FLAG = chkUseStockChecked;

                activities.Add(activity);
            }
        }

        //Insert/Update data
        if (activities.Count == 0)
        {
            ClientScriptManager cs = Page.ClientScript;
            cs.RegisterStartupScript(this.GetType(), "Warn", "alert('Please select a patient to order a kit.');", true);
        }
        else
        {
            _labkitMgr.InsertActivities(activities);
            //Bind Data or redirect to the Kit orders page, if redirect, saving params to view state not required.
            //BindData(Convert.ToInt32(ViewState["InstitutionId"]), Convert.ToInt32(ViewState["KitTypeId"]));
            ReDirectPage();
        }
    }

    protected void BindData(int institutionId, int kitTypeId)
    {
        //List<LabKitOrderPatientsBO> Patients=null;

        //Patients = _labkitMgr.GetNewLabKitOrders(institutionId, kitTypeId);
        //if (Patients.Count > 0)
        //{
        //    lblInstName.Text = Patients[0].InstName;
        //    lblKitType.Text = Patients[0].KitType;
        //}

        //BreadCrumbLabel.Text = BreadCrumbLabel.Text + Patients[0].InstName;  
        //GridViewLabKits.DataSource = Patients;
        //GridViewLabKits.DataBind();
    }

    private WKF_CASE_ACTIVITY LoadFormDataToObjects(WKF_CASE_ACTIVITY Activity, GridViewRow Row)
    {
        Activity.WKF_CASE_ID = Convert.ToInt32(GridViewLabKits.DataKeys[Row.RowIndex].Value);
        Activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.Tracking); //Kit ordered
        Activity.STD_WKFACTIVITYTYPE_ID = Convert.ToInt32(WorkFlowActivityTypes.LabKit);
        Activity.REPRESENTATIVE_NAME = _labkitMgr.UserName;
        Activity.CONTACT_NAME = ((TextBox)Row.FindControl("txtVAMCContact")).Text.Trim();
        Activity.CONTACT_PHONE = ((TextBox)Row.FindControl("txtVAMCContactPh")).Text.Trim();
        Activity.ADDRESS_LINE1 = ((TextBox)Row.FindControl("txtAddressLine1")).Text.Trim();
        Activity.ADDRESS_LINE2 = ((TextBox)Row.FindControl("txtAddressLine2")).Text.Trim();
        Activity.ADDRESS_LINE3 = ((TextBox)Row.FindControl("txtAddressLine3")).Text.Trim();
        Activity.CITY = ((TextBox)Row.FindControl("txtCity")).Text.Trim();
        Activity.STATE = ((TextBox)Row.FindControl("txtState")).Text.Trim();
        Activity.COUNTRY = ((TextBox)Row.FindControl("txtCountry")).Text.Trim();
        Activity.POSTAL_CODE = ((TextBox)Row.FindControl("txtPostalCode")).Text.Trim();
        Activity.ZIP_PLUS_4 = ((TextBox)Row.FindControl("txtZip")).Text.Trim();
        Activity.KIT_ORDER_DATE = Helpers.ConvertStringToNullable<DateTime>(((controls_FromToDate)Row.FindControl("OrderDate")).DateValue);
        Activity.COUNTRY = ((TextBox)Row.FindControl("txtCountry")).Text.Trim();
        return Activity;
    }

    private void ReDirectPage()
    {
        Response.Redirect("LabKitOrders.aspx");
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        ReDirectPage();
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "LabKitOrders";
    }

    public override string AppObjectCode()
    {
        return "LabKitOrders";
    }
    protected void GridViewLabKits_Sorting(object sender, GridViewSortEventArgs e)
    {
    }
    protected void ObjectDataSourceLabKits_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {
        if (!e.ReturnValue.GetType().IsValueType)
            if (((List<LabKitOrderPatientsBO>)e.ReturnValue).Count() > 0)
            {
                List<LabKitOrderPatientsBO> Patients = (List<LabKitOrderPatientsBO>)e.ReturnValue;
                lblInstName.Text = Patients[0].InstName;
                lblKitType.Text = Patients[0].KitType;
                if(!IsPostBack) BreadCrumbLabel.Text = BreadCrumbLabel.Text + Patients[0].InstName;  
            }
    }
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        {
            //if ((e.Row.RowType == DataControlRowType.DataRow))
            //{
            //    ((CheckBox)e.Row.FindControl("chkUseStock")).Attributes.Add("onclick", "javascript:checkMutuallyExclusive('" + ((CheckBox)e.Row.FindControl("chkPatId")).ClientID + "')");
            //    ((CheckBox)e.Row.FindControl("chkPatId")).Attributes.Add("onclick", "javascript:checkMutuallyExclusive('" + ((CheckBox)e.Row.FindControl("chkUseStock")).ClientID + "')");
            //}
        } 

    }
}
